unit TConnDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, OleCtrls, comobj, ExtCtrls, TCONNECTOR2Lib_TLB, Variants;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    btnOpen: TButton;
    btnClose: TButton;
    Label1: TLabel;
    Label2: TLabel;
    GroupBox2: TGroupBox;
    btnRead: TButton;
    btnWrite: TButton;
    eBytes: TEdit;
    eTimeout: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    eWriteData: TEdit;
    GroupBox3: TGroupBox;
    btnStartListen: TButton;
    btnStopListen: TButton;
    btnConfiguration: TButton;
    btnLicense: TButton;
    btnAbout: TButton;
    meListenData: TMemo;
    Label7: TLabel;
    Label8: TLabel;
    Image1: TImage;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    GroupBox4: TGroupBox;
    Label12: TLabel;
    Label13: TLabel;
    lbStatus: TListBox;
    Label14: TLabel;
    TConnector2: TTConnector2;

    procedure btnOpenClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure btnConfigurationClick(Sender: TObject);
    procedure btnLicenseClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure btnReadClick(Sender: TObject);
    procedure btnWriteClick(Sender: TObject);
    procedure btnStartListenClick(Sender: TObject);
    procedure TConnOnData(Sender: TObject; const Data: WideString);
    procedure OnCreateForm(Sender: TObject);
    procedure btnStopListenClick(Sender: TObject);
    procedure TCPClosed(Sender: TObject);
    procedure TConnAsyncError(Sender: TObject; hr: Integer);
    procedure TConnStatusChange(Sender: TObject; vStates: OleVariant);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.btnOpenClick(Sender: TObject);
var sErrortext: String;
begin

        try
        //open connection
        TConnector2.Open();

        // disable open butten (to avoid twice opening which would cause an error)
        btnOpen.Enabled := False;
        btnConfiguration.Enabled := False;

        except
           on E: EOleException do
           begin
                // To get the error message for this error use:
                sErrortext := TConnector2.TranslateErrorNo(Integer(E.ErrorCode));
                MessageDlg (sErrortext, mtWarning, [mbOK], 0);
           end;
        end;
end;

procedure TForm1.btnCloseClick(Sender: TObject);
begin
//close connection
        TConnector2.Close();

//enable buttons
        btnOpen.Enabled := True;
        btnConfiguration.Enabled := True;
end;

procedure TForm1.btnConfigurationClick(Sender: TObject);
begin
        TConnector2.PropertyDialog();  //open property dialog (set communication parameters)
end;

procedure TForm1.btnLicenseClick(Sender: TObject);
begin
        //call the license dialog
        TConnector2.Licensing ();

        // or license by passing the license data
        // TConnector2.LicenseMe ("LicenseeName", eLicKindSite, 1, "LicenseKey", eLicProdStd);
end;

procedure TForm1.btnAboutClick(Sender: TObject);
begin
        TConnector2.AboutBox ();
end;

procedure TForm1.btnReadClick(Sender: TObject);
var sData: String; //received data
var sErrortext: String;
var nBytes: Integer;  //number of bytes to receive (received)
var nTimeout: Integer;//timeout in msec [0.001s]
begin

        try
           nBytes := StrToInt(eBytes.Text);     //max Bytes per Scan
           nTimeout := StrToInt(eTimeout.Text); //time to wait for data and then return
           nTimeout := nTimeout * 1000;          //Timeout has to be set in 0.001 sec

           // connection (device) must have been opened
           If TConnector2.IsOpen then
           begin
                sData  := TConnector2.Read(nBytes, nTimeout);    //read nBytes within nTimeout
                nBytes := TConnector2.GetNoOfBytesRead();
                MessageDlg (IntToStr(nBytes) + ' Bytes received: ' + sData, mtInformation, [mbOK], 0);
           end
           else
                MessageDlg ('Open connection first !', mtWarning, [mbOK], 0);

        except
           on EConvertError do
              MessageDlg ('Enter valid data (Bytes and Timeout)', mtWarning, [mbOK], 0);
           on E: EOleException do
           begin
              sErrortext := TConnector2.TranslateErrorNo(Integer(E.ErrorCode));
              MessageDlg (sErrortext, mtWarning, [mbOK], 0);
           end;
        end;
end;


procedure TForm1.btnWriteClick(Sender: TObject);
var sData: String;    //data to write
var nBytes: Integer;  //number of bytes to write
var nBytesWritten: Integer;
var nTimeout: Integer;//timeout in msec [0.001s]
begin

        try
           sData    := eWriteData.Text;
           nBytes   := Length(sData);   // max Bytes per Scan
           nTimeout := 2000;            // 2 sec time to wait until all data has been sent

           // if connection was opend with button open
           if (TConnector2.IsOpen) then
           begin
                nBytesWritten := TConnector2.Write (nBytes, nTimeout, sData);
                MessageDlg (IntToStr(nBytesWritten) + ' Bytes written to: ' + TConnector2.Device, mtInformation, [mbOK], 0);
           end
           else
                MessageDlg ('Open connection first !', mtWarning, [mbOK], 0);

        except
           on EConvertError do
              MessageDlg ('Enter valid data!', mtWarning, [mbOK], 0);
           on E: EOleException do
           begin
              // Errortext := TConnector2.TranslateErrorNo(Integer(E.ErrorCode));
              MessageDlg ('Error: could not write to device', mtWarning, [mbOK], 0);
           end;
        end;
end;

procedure TForm1.btnStartListenClick(Sender: TObject);
var Errortext: String;
begin
        try
          if TConnector2.IsOpen then
          begin
                meListenData.Text := '';
                TConnector2.StartListen(); // OnData event is fired when data is received
                Form1.btnStartListen.Enabled := False;
          end
          else
                MessageDlg ('Open connection first!', mtWarning, [mbOK], 0);
        except
           on E: EOleException do
           begin
              Errortext := TConnector2.TranslateErrorNo(Integer(E.ErrorCode));
              MessageDlg (Errortext, mtWarning, [mbOK], 0);
           end;
        end;
end;

procedure TForm1.TConnOnData(Sender: TObject; const Data: WideString);
var nBytes: Integer;
begin

nBytes:= TConnector2.GetNoOfBytesRead();



        meListenData.Text     := meListenData.Text + '(' + IntToStr(nBytes) + IntToStr(Length(Data)) + ') Bytes: ' + Data;
        meListenData.SelStart := Length(meListenData.Text); //move cursor to last position
        lbStatus.Items.Add ('- - - - - - - - -');                  // mark end of data in status listbox
end;

procedure TForm1.OnCreateForm(Sender: TObject);
begin
        // todo: form initialisation

end;

procedure TForm1.btnStopListenClick(Sender: TObject);
begin
        TConnector2.StopListen();
        Form1.btnStartListen.Enabled := True;
end;

// event is fired when connection is terminated by server (only TCP connections)
procedure TForm1.TCPClosed(Sender: TObject);
begin

//enable buttons
        btnStartListen.Enabled := True;
        btnOpen.Enabled := True;
        btnConfiguration.Enabled := True;

        MessageDlg ('Connection has been closed by the server...', mtWarning, [mbOK], 0);
end;

// event is fired when error occurs in async mode (Listen mode)
procedure TForm1.TConnAsyncError(Sender: TObject; hr: Integer);
var errtext:String;
begin
        errtext := TConnector2.TranslateErrorNo(hr);
        MessageDlg (errtext, mtWarning, [mbOK], 0);
end;

procedure TForm1.TConnStatusChange(Sender: TObject; vStates: OleVariant);
var
  sState:String;
  I: Integer;
begin

   // vStates is an array representing one or multiple state changes
   // of the status lines
   // definition of enums/states --> refer to the documentation
   for I := 0 to VarArrayHighBound (vStates, 1) do
   begin
       sState := TConnector2.StateAsTxt[vStates[I]];
       lbStatus.Items.Add (sState);
   end;
end;

end.
