unit Connector;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, OleCtrls, TCONNECTORLib_TLB, comobj, ExtCtrls;

var vRead: Variant;
var sEnd: string;

type
  TForm1 = class(TForm)
    Connector1: TConnector;
    Button1: TButton;
    Edit1: TEdit;
    Button2: TButton;
    Button3: TButton;
    ListBox1: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    Image1: TImage;
    StaticText1: TStaticText;
    StaticText2: TStaticText;
    procedure Button1Click(Sender: TObject);
    procedure Connector1Data(Sender: TObject; const Data: WideString);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var Bytes: Integer;
var TimeOut: Integer;

begin
        Connector1.Close(); // if it was previous opened
        Connector1.Open();
        Bytes := 50;     //max Bytes per Scan
        TimeOut := 5000; //return the scanned value after [5000] msec = 5 sec
        try
           vRead := Connector1.Read (Bytes, TimeOut);
           Edit1.Text := vRead;
        except
           on EOleException do
              MessageDlg ('No data received: press Scan Once and scan within 5 secs!', mtWarning, [mbOK], 0);
           end;
        Connector1.Close();
end;

procedure TForm1.Connector1Data(Sender: TObject; const Data: WideString);
begin
        Edit1.Text := Data;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
        Connector1.StopListen();
        Connector1.Close();
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
        try
        Connector1.Close(); // if it was previously opened
        Connector1.Open();
        Connector1.StartListen();
        except
         on EOleException do
             MessageDlg ('Error!', mtWarning, [mbOK], 0);
         end;

end;

procedure TForm1.ListBox1Click(Sender: TObject);
var index : Integer;
begin
    index :=  ListBox1.ItemIndex + 1;
        try
           Connector1.Device := 'com' + IntToStr(index);
           Connector1.Close(); // close to avoid errors if it was prev. opened
           Connector1.Open();
        except
          on EOleException do
             MessageDlg ('No valid COM Port!', mtWarning, [mbOK], 0);
          end;
end;

end.
